/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.impl.tags;

import com.mojang.datafixers.util.Pair;
import io.github.lukebemish.dynamic_asset_generator.api.IPathAwareInputStreamSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TagBuilder
implements IPathAwareInputStreamSource {
    private final List<Supplier<Set<ResourceLocation>>> paths = new ArrayList<Supplier<Set<ResourceLocation>>>();
    private final ResourceLocation location;
    private final ResourceLocation tagLocation;
    private final List<Supplier<Map<ResourceLocation, Set<ResourceLocation>>>> queue;

    public TagBuilder(ResourceLocation location, ResourceLocation tagLocation, List<Supplier<Map<ResourceLocation, Set<ResourceLocation>>>> queue) {
        this.location = location;
        this.tagLocation = tagLocation;
        this.queue = queue;
    }

    public void add(Pair<ResourceLocation, Supplier<Boolean>> p) {
        this.paths.add(() -> Boolean.TRUE.equals(((Supplier)p.getSecond()).get()) ? Set.of((ResourceLocation)p.getFirst()) : Set.of());
    }

    public void add(Supplier<Set<ResourceLocation>> rls) {
        this.paths.add(rls);
    }

    @Override
    @NotNull
    public Supplier<InputStream> get(ResourceLocation outRl) {
        return this::build;
    }

    private InputStream build() {
        StringBuilder internal = new StringBuilder();
        HashSet toAdd = new HashSet();
        for (Supplier<Set<ResourceLocation>> supplier : this.paths) {
            toAdd.addAll(supplier.get());
        }
        for (Supplier<Object> supplier : this.queue) {
            toAdd.addAll(((Map)supplier.get()).getOrDefault(this.tagLocation, Set.of()));
        }
        toAdd.forEach(rl -> {
            if (internal.length() >= 1) {
                internal.append(",\n");
            }
            internal.append("    \"").append(rl.m_135827_()).append(":").append(rl.m_135815_()).append("\"");
        });
        String json = "{\n  \"replace\":false,\n  \"values\":[" + internal + "\n]}";
        return new ByteArrayInputStream(json.getBytes());
    }

    @Override
    @NotNull
    public Set<ResourceLocation> getLocations() {
        return Set.of(this.location);
    }
}

