/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.client.render.be;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.client.event.TextureStitchEvent;
import vazkii.quark.base.client.render.GenericChestBERenderer;
import vazkii.quark.content.building.module.VariantChestsModule;

public class VariantChestRenderer
extends GenericChestBERenderer<ChestBlockEntity> {
    private static final Map<Block, ChestTextureBatch> chestTextures = new HashMap<Block, ChestTextureBatch>();

    public VariantChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public Material getMaterial(ChestBlockEntity t, ChestType type) {
        Block block = t.m_58900_().m_60734_();
        ChestTextureBatch batch = chestTextures.get(block);
        if (batch == null) {
            return null;
        }
        return switch (type) {
            case ChestType.LEFT -> batch.left;
            case ChestType.RIGHT -> batch.right;
            default -> batch.normal;
        };
    }

    public static void accept(TextureStitchEvent.Pre event, Block chest) {
        ResourceLocation atlas = event.getAtlas().m_118330_();
        if (chest instanceof VariantChestsModule.IChestTextureProvider) {
            VariantChestsModule.IChestTextureProvider prov = (VariantChestsModule.IChestTextureProvider)chest;
            String path = prov.getChestTexturePath();
            if (prov.isTrap()) {
                VariantChestRenderer.add(event, atlas, chest, path, "trap", "trap_left", "trap_right");
            } else {
                VariantChestRenderer.add(event, atlas, chest, path, "normal", "left", "right");
            }
        }
    }

    private static void add(TextureStitchEvent.Pre event, ResourceLocation atlas, Block chest, String path, String normal, String left, String right) {
        ResourceLocation resNormal = new ResourceLocation("quark", path + normal);
        ResourceLocation resLeft = new ResourceLocation("quark", path + left);
        ResourceLocation resRight = new ResourceLocation("quark", path + right);
        ChestTextureBatch batch = new ChestTextureBatch(atlas, resNormal, resLeft, resRight);
        chestTextures.put(chest, batch);
        event.addSprite(resNormal);
        event.addSprite(resLeft);
        event.addSprite(resRight);
    }

    private static class ChestTextureBatch {
        public final Material normal;
        public final Material left;
        public final Material right;

        public ChestTextureBatch(ResourceLocation atlas, ResourceLocation normal, ResourceLocation left, ResourceLocation right) {
            this.normal = new Material(atlas, normal);
            this.left = new Material(atlas, left);
            this.right = new Material(atlas, right);
        }
    }
}

