/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.claim;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.claim.ClaimStorage;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import vazkii.quark.base.Quark;
import vazkii.quark.integration.claim.IClaimIntegration;

public final class FlanIntegration
implements IClaimIntegration {
    @Override
    public boolean canBreak(@Nonnull Player player, @Nonnull BlockPos pos) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.BREAK, pos, true);
        }
        catch (Exception e) {
            Quark.LOG.error("Failed call break block event: [Player: {}, Pos: {}]", (Object)player, (Object)pos, (Object)e);
            return true;
        }
    }

    @Override
    public boolean canPlace(@Nonnull Player player, @Nonnull BlockPos pos) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.PLACE, pos);
        }
        catch (Exception e) {
            Quark.LOG.error("Failed call place block event: [Player: {}, Pos: {}]", (Object)player, (Object)pos, (Object)e);
            return true;
        }
    }

    @Override
    public boolean canReplace(@Nonnull Player player, @Nonnull BlockPos pos) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.PLACE, pos);
        }
        catch (Exception e) {
            Quark.LOG.error("Failed call replace block event: [Player: {}, Pos: {}]", (Object)player, (Object)pos, (Object)e);
            return true;
        }
    }

    @Override
    public boolean canAttack(@Nonnull Player player, @Nonnull Entity victim) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(victim.m_20183_());
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.HURTANIMAL, victim.m_20183_());
        }
        catch (Exception e) {
            Quark.LOG.error("Failed call attack entity event: [Player: {}, Victim: {}]", (Object)player, (Object)victim, (Object)e);
            return true;
        }
    }

    @Override
    public boolean canInteract(@Nonnull Player player, @Nonnull BlockPos targetPos) {
        if (player.f_19853_.f_46443_) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.f_19853_));
            IPermissionContainer claim = storage.getForPermissionCheck(targetPos);
            return claim.canInteract((ServerPlayer)player, PermissionRegistry.INTERACTBLOCK, targetPos);
        }
        catch (Exception e) {
            Quark.LOG.error("Failed call interact event: [Player: {}, Pos: {}]", (Object)player, (Object)targetPos, (Object)e);
            return true;
        }
    }
}

