/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonFeatures;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.DungeonType;
import xiroc.dungeoncrawl.dungeon.Tile;
import xiroc.dungeoncrawl.dungeon.generator.DefaultDungeonGenerator;
import xiroc.dungeoncrawl.dungeon.generator.DungeonGenerator;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonEntrance;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.Position2D;

public class DungeonBuilder {
    public static final DungeonGenerator DEFAULT_GENERATOR = new DefaultDungeonGenerator();
    public Position2D start;
    public DungeonLayer[] layers;
    public BlockPos startPos;
    public Structure.GenerationContext generationContext;
    public Biome biome;
    public Theme theme;
    public Theme catacombsTheme;
    public Theme lowerCatacombsTheme;
    public Theme bottomTheme;
    public SecondaryTheme secondaryTheme;
    public SecondaryTheme catacombsSecondaryTheme;
    public SecondaryTheme lowerCatacombsSecondaryTheme;
    public SecondaryTheme bottomSecondaryTheme;
    private final int groundHeight;
    private static final int GRID_SIZE = 17;
    private static final int HALF_GRID_SIZE = 8;

    public DungeonBuilder(Structure.GenerationContext generationContext, int startHeight, BlockPos groundPos) {
        this.generationContext = generationContext;
        this.groundHeight = groundPos.m_123342_();
        this.startPos = new BlockPos(generationContext.f_226628_().f_45578_ * 16 - 72 - 4, startHeight, generationContext.f_226628_().f_45579_ * 16 - 72 - 4);
        DungeonCrawl.LOGGER.debug("Creating a dungeon at (" + this.startPos.m_123341_() + " | " + this.startPos.m_123342_() + " | " + this.startPos.m_123343_() + ").");
    }

    public List<DungeonPiece> build() {
        if (this.startPos.m_123342_() < 16) {
            return Lists.newArrayList();
        }
        this.biome = (Biome)this.generationContext.f_226622_().m_62218_().m_203407_(QuartPos.m_175400_((int)this.startPos.m_123341_()), QuartPos.m_175400_((int)this.groundHeight), QuartPos.m_175400_((int)this.startPos.m_123343_()), this.generationContext.f_226624_().m_224579_()).m_203334_();
        DungeonType type = DungeonType.randomType(this.generationContext.f_226621_().m_175515_(Registry.f_122885_).m_7981_((Object)this.biome), (RandomSource)this.generationContext.f_226626_());
        this.generateLayout(type, DEFAULT_GENERATOR);
        ArrayList pieces = Lists.newArrayList();
        DungeonEntrance entrance = new DungeonEntrance();
        entrance.setWorldPosition(this.startPos.m_123341_() + this.layers[0].start.x * 9, this.startPos.m_123342_() + 9, this.startPos.m_123343_() + this.layers[0].start.z * 9);
        entrance.stage = 0;
        entrance.model = type.entrances().roll((RandomSource)this.generationContext.f_226626_());
        ((DungeonPiece)entrance).createBoundingBox();
        this.determineThemes();
        entrance.theme = this.theme;
        entrance.secondaryTheme = this.secondaryTheme;
        pieces.add(entrance);
        this.postProcessDungeon(pieces, type, (RandomSource)this.generationContext.f_226626_());
        return pieces;
    }

    private void generateLayout(DungeonType type, DungeonGenerator generator) {
        int layer;
        generator.initializeDungeon(type, this, this.generationContext.f_226628_(), (RandomSource)this.generationContext.f_226626_());
        this.start = new Position2D(8, 8);
        int layerCount = generator.layerCount((RandomSource)this.generationContext.f_226626_(), this.startPos.m_123342_() - this.generationContext.f_226622_().m_142062_());
        this.layers = new DungeonLayer[layerCount];
        for (layer = 0; layer < this.layers.length; ++layer) {
            this.layers[layer] = new DungeonLayer(17);
        }
        for (layer = 0; layer < this.layers.length && (layer <= 0 || this.layers[layer - 1].end != null); ++layer) {
            generator.initializeLayer(type.getLayer(layer).settings(), this, (RandomSource)this.generationContext.f_226626_(), layer, layer == layerCount - 1);
            generator.generateLayer(this, this.layers[layer], layer, (RandomSource)this.generationContext.f_226626_(), layer == 0 ? this.start : this.layers[layer - 1].end);
        }
        for (layer = 0; layer < this.layers.length; ++layer) {
            this.processCorridors(this.layers[layer], layer);
        }
    }

    private void processCorridors(DungeonLayer layer, int lyr) {
        int stage = Math.min(lyr, 4);
        for (int x = 0; x < layer.width; ++x) {
            for (int z = 0; z < layer.length; ++z) {
                if (layer.grid[x][z] == null || layer.grid[x][z].hasFlag(Tile.Flag.PLACEHOLDER)) continue;
                layer.grid[x][z].piece.stage = stage;
                if (layer.grid[x][z].piece.getDungeonPieceType() != 0) continue;
                DungeonFeatures.processCorridor(this, layer, x, z, (RandomSource)this.generationContext.f_226626_(), lyr, stage, this.startPos);
            }
        }
    }

    private void determineThemes() {
        ResourceLocation registryName = this.generationContext.f_226621_().m_175515_(Registry.f_122885_).m_7981_((Object)this.biome);
        if (registryName != null) {
            if (this.theme == null) {
                this.theme = Theme.randomTheme(registryName.toString(), (RandomSource)this.generationContext.f_226626_());
            }
        } else if (this.theme == null) {
            this.theme = Theme.getBuiltinDefaultTheme();
        }
        if (this.secondaryTheme == null) {
            if (this.theme.secondaryTheme != null) {
                this.secondaryTheme = this.theme.secondaryTheme.roll((RandomSource)this.generationContext.f_226626_());
            } else {
                SecondaryTheme secondaryTheme = this.secondaryTheme = registryName != null ? Theme.randomSecondaryTheme(registryName.toString(), (RandomSource)this.generationContext.f_226626_()) : Theme.getBuiltinDefaultSecondaryTheme();
            }
        }
        if (this.catacombsTheme == null) {
            this.catacombsTheme = Theme.randomCatacombsTheme((RandomSource)this.generationContext.f_226626_());
        }
        if (this.catacombsSecondaryTheme == null) {
            this.catacombsSecondaryTheme = this.catacombsTheme.secondaryTheme != null ? this.catacombsTheme.secondaryTheme.roll((RandomSource)this.generationContext.f_226626_()) : Theme.randomCatacombsSecondaryTheme((RandomSource)this.generationContext.f_226626_());
        }
        if (this.lowerCatacombsTheme == null) {
            this.lowerCatacombsTheme = Theme.randomLowerCatacombsTheme((RandomSource)this.generationContext.f_226626_());
        }
        if (this.lowerCatacombsSecondaryTheme == null) {
            this.lowerCatacombsSecondaryTheme = this.lowerCatacombsTheme.secondaryTheme != null ? this.lowerCatacombsTheme.secondaryTheme.roll((RandomSource)this.generationContext.f_226626_()) : Theme.randomLowerCatacombsSecondaryTheme((RandomSource)this.generationContext.f_226626_());
        }
        if (this.bottomTheme == null) {
            this.bottomTheme = (Boolean)Config.NO_NETHER_STUFF.get() != false ? Theme.getTheme(Theme.PRIMARY_HELL_MOSSY) : Theme.randomHellTheme((RandomSource)this.generationContext.f_226626_());
        }
        this.bottomSecondaryTheme = this.bottomTheme.secondaryTheme != null && this.bottomSecondaryTheme == null ? this.bottomTheme.secondaryTheme.roll((RandomSource)this.generationContext.f_226626_()) : Theme.randomHellSecondaryTheme((RandomSource)this.generationContext.f_226626_());
    }

    private void postProcessDungeon(List<DungeonPiece> pieces, DungeonType type, RandomSource rand) {
        for (int i = 0; i < this.layers.length; ++i) {
            DungeonLayer layer = this.layers[i];
            ModelSelector modelSelector = type.getLayer(i).modelSelector();
            for (int x = 0; x < layer.width; ++x) {
                for (int z = 0; z < layer.length; ++z) {
                    Tile tile = layer.grid[x][z];
                    if (tile == null || tile.hasFlag(Tile.Flag.PLACEHOLDER)) continue;
                    switch (i) {
                        case 2: {
                            tile.piece.theme = this.catacombsTheme;
                            tile.piece.secondaryTheme = this.catacombsSecondaryTheme;
                            break;
                        }
                        case 3: {
                            tile.piece.theme = this.lowerCatacombsTheme;
                            tile.piece.secondaryTheme = this.lowerCatacombsSecondaryTheme;
                            break;
                        }
                        default: {
                            if (i >= 4) {
                                tile.piece.theme = this.bottomTheme;
                                tile.piece.secondaryTheme = this.bottomSecondaryTheme;
                                break;
                            }
                            tile.piece.theme = this.theme;
                            tile.piece.secondaryTheme = this.secondaryTheme;
                        }
                    }
                    if (!tile.hasFlag(Tile.Flag.FIXED_MODEL)) {
                        tile.piece.setupModel(this, modelSelector, pieces, rand);
                    }
                    if (!tile.hasFlag(Tile.Flag.FIXED_POSITION)) {
                        tile.piece.setWorldPosition(this.startPos.m_123341_() + x * 9, this.startPos.m_123342_() - i * 9, this.startPos.m_123343_() + z * 9);
                    }
                    tile.piece.createBoundingBox();
                    if (tile.piece.getDungeonPieceType() == 10) {
                        layer.rotateNode(tile, rand);
                    }
                    if (tile.piece.hasChildPieces()) {
                        tile.piece.addChildPieces(pieces, this, type, modelSelector, i, rand);
                    }
                    tile.piece.setup(rand);
                    pieces.add(tile.piece);
                }
            }
        }
    }

    public static boolean isBlockProtected(LevelAccessor world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60800_((BlockGetter)world, pos) < 0.0f;
    }
}

