/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.WaterFluid;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.theme.Theme;

public final class PillarGenerator {
    public static void generateFancyPillar(LevelAccessor world, BlockPos center, RandomSource random, BoundingBox worldGenBounds, Theme primaryTheme) {
        BlockPos west;
        BlockPos south;
        BlockPos east;
        BlockPos north;
        if (worldGenBounds.m_71051_((Vec3i)center)) {
            PillarGenerator.generateSimplePillar(world, center, primaryTheme, random);
        }
        if (world.m_7232_((north = center.m_122012_()).m_123341_() >> 4, north.m_123343_() >> 4)) {
            PillarGenerator.placeTopStair(world, north, Direction.SOUTH, primaryTheme, random);
        }
        if (world.m_7232_((east = center.m_122029_()).m_123341_() >> 4, east.m_123343_() >> 4)) {
            PillarGenerator.placeTopStair(world, east, Direction.WEST, primaryTheme, random);
        }
        if (world.m_7232_((south = center.m_122019_()).m_123341_() >> 4, south.m_123343_() >> 4)) {
            PillarGenerator.placeTopStair(world, south, Direction.NORTH, primaryTheme, random);
        }
        if (world.m_7232_((west = center.m_122024_()).m_123341_() >> 4, west.m_123343_() >> 4)) {
            PillarGenerator.placeTopStair(world, west, Direction.EAST, primaryTheme, random);
        }
    }

    private static void placeTopStair(LevelAccessor world, BlockPos pos, Direction toCenter, Theme primaryTheme, RandomSource random) {
        if (world.m_46859_(pos) && world.m_8055_(pos.m_7494_()).m_60815_()) {
            BlockState stair = DungeonBlocks.applyProperty(primaryTheme.solidStairs.get(world, pos, random), BlockStateProperties.f_61374_, toCenter);
            stair = DungeonBlocks.applyProperty(stair, BlockStateProperties.f_61402_, Half.TOP);
            if (world.m_6425_(pos).m_76152_() instanceof WaterFluid) {
                stair = DungeonBlocks.applyProperty(stair, BlockStateProperties.f_61362_, true);
            }
            world.m_7731_(pos, stair, 2);
        }
    }

    public static void generateSimplePillar(LevelAccessor world, BlockPos pos, Theme primaryTheme, RandomSource random) {
        while (pos.m_123342_() > 0) {
            if (world.m_8055_(pos).m_60815_()) {
                return;
            }
            world.m_7731_(pos, primaryTheme.solid.get(world, pos, random), 2);
            pos = pos.m_7495_();
        }
    }
}

