/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crops.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crops.crops.BaseCrop;
import ic2.core.platform.rendering.IC2Textures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoneFlowerCrop
extends BaseCrop {
    public BoneFlowerCrop() {
        super("bone_flower", new CropProperties(6, 2, 0, 0, 0, 0), "Flower", "BoneMeal", "White");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTexture(int stage) {
        return IC2Textures.getMappedEntriesBlockIC2("crops/bone_flower").get("growing_" + stage);
    }

    @Override
    public Component discoveredBy() {
        return BaseCrop.NANO_HEART;
    }

    @Override
    public ItemStack getDisplayItem() {
        return new ItemStack((ItemLike)Items.f_42499_);
    }

    @Override
    public int getGrowthSteps() {
        return 7;
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        if (cropTile.getGrowthStage() < 3) {
            return true;
        }
        return cropTile.isBlockBelow(Blocks.f_50453_);
    }

    @Override
    public ItemStack[] getDrops(ICropTile cropTile) {
        return new ItemStack[]{new ItemStack((ItemLike)Items.f_42500_)};
    }
}

