/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blocks;

import com.finallion.graveyard.blockentities.SarcophagusBlockEntity;
import com.finallion.graveyard.blockentities.enums.SarcophagusPart;
import com.finallion.graveyard.blocks.AbstractCoffinBlock;
import com.finallion.graveyard.entities.WraithEntity;
import com.finallion.graveyard.init.TGAdvancements;
import com.finallion.graveyard.init.TGEntities;
import com.finallion.graveyard.init.TGTileEntities;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SarcophagusBlock
extends AbstractCoffinBlock<SarcophagusBlockEntity>
implements SimpleWaterloggedBlock {
    public static final int EVENT_SET_OPEN_COUNT = 1;
    protected static final VoxelShape DOUBLE_NORTH_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape DOUBLE_SOUTH_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape DOUBLE_WEST_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape DOUBLE_EAST_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<SarcophagusPart> PART = EnumProperty.m_61587_((String)"part", SarcophagusPart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty PLAYER_PLACED = BlockStateProperties.f_61444_;
    public static final BooleanProperty IS_COFFIN = BlockStateProperties.f_61443_;
    private final String lidRL;
    private final String baseRL;

    public SarcophagusBlock(BlockBehaviour.Properties properties, boolean isCoffin, String lid, String base) {
        super(properties, () -> TGTileEntities.SARCOPHAGUS_BLOCK_ENTITY.get());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)SarcophagusPart.FOOT))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_COFFIN, (Comparable)Boolean.valueOf(isCoffin)));
        this.baseRL = base;
        this.lidRL = lid;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51562_) {
        p_51562_.m_61104_(new Property[]{WATERLOGGED, OPEN, FACING, PART, PLAYER_PLACED, IS_COFFIN});
    }

    public FluidState m_5888_(BlockState p_51581_) {
        return (Boolean)p_51581_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_51581_);
    }

    public BlockState m_7417_(BlockState p_49525_, Direction p_49526_, BlockState p_49527_, LevelAccessor p_49528_, BlockPos p_49529_, BlockPos p_49530_) {
        if (p_49526_ == SarcophagusBlock.getNeighbourDirection((SarcophagusPart)((Object)p_49525_.m_61143_(PART)), (Direction)p_49525_.m_61143_((Property)FACING))) {
            return p_49527_.m_60713_((Block)this) && p_49527_.m_61143_(PART) != p_49525_.m_61143_(PART) ? p_49525_ : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(p_49525_, p_49526_, p_49527_, p_49528_, p_49529_, p_49530_);
    }

    private static Direction getNeighbourDirection(SarcophagusPart p_49534_, Direction p_49535_) {
        return p_49534_ == SarcophagusPart.FOOT ? p_49535_ : p_49535_.m_122424_();
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }

    public VoxelShape m_5940_(BlockState p_51569_, BlockGetter p_51570_, BlockPos p_51571_, CollisionContext p_51572_) {
        switch ((Direction)p_51569_.m_61143_((Property)FACING)) {
            default: {
                return DOUBLE_NORTH_SHAPE;
            }
            case SOUTH: {
                return DOUBLE_SOUTH_SHAPE;
            }
            case WEST: {
                return DOUBLE_WEST_SHAPE;
            }
            case EAST: 
        }
        return DOUBLE_EAST_SHAPE;
    }

    public InteractionResult m_6227_(BlockState p_49515_, Level p_49516_, BlockPos p_49517_, Player p_49518_, InteractionHand p_49519_, BlockHitResult p_49520_) {
        MenuProvider menuprovider;
        Random random = new Random();
        if (p_49516_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        BlockPos original = p_49517_;
        if (p_49515_.m_61143_(PART) == SarcophagusPart.HEAD) {
            p_49517_ = p_49517_.m_121945_(((Direction)p_49515_.m_61143_((Property)FACING)).m_122424_());
        }
        if ((menuprovider = this.m_7246_(p_49515_, p_49516_, p_49517_)) != null) {
            p_49518_.m_5893_(menuprovider);
        }
        SarcophagusBlock.spawnGhost(p_49515_, p_49516_, original, p_49518_, random);
        return InteractionResult.CONSUME;
    }

    private static Direction getDirectionTowardsOtherPart(SarcophagusPart part, Direction direction) {
        return part == SarcophagusPart.FOOT ? direction : direction.m_122424_();
    }

    public static void spawnGhost(BlockState state, Level world, BlockPos pos, Player player, Random random) {
        if (!((Boolean)state.m_61143_((Property)PLAYER_PLACED)).booleanValue() && random.nextInt(4) == 0 && pos.m_123342_() < 62) {
            BlockPos entityPos = pos;
            for (int i = 0; !(i >= 10 || world.m_8055_(entityPos = player.m_20097_().m_7918_(-2 + random.nextInt(5), 1, -2 + random.nextInt(5))).m_60795_() && world.m_8055_(entityPos.m_7494_()).m_60795_()); ++i) {
            }
            WraithEntity ghost = (WraithEntity)((EntityType)TGEntities.WRAITH.get()).m_20615_(world);
            ghost.m_20035_(entityPos, 0.0f, 0.0f);
            world.m_7967_((Entity)ghost);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(true)), 3);
            BlockPos otherPartPos = pos.m_121945_(SarcophagusBlock.getDirectionTowardsOtherPart((SarcophagusPart)((Object)state.m_61143_(PART)), (Direction)state.m_61143_((Property)FACING)));
            BlockState otherPart = world.m_8055_(otherPartPos);
            if (player instanceof ServerPlayer) {
                TGAdvancements.SPAWN_WRAITH.trigger((ServerPlayer)player);
            }
            world.m_7731_(otherPartPos, (BlockState)otherPart.m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void m_6402_(Level p_49499_, BlockPos p_49500_, BlockState p_49501_, @javax.annotation.Nullable LivingEntity p_49502_, ItemStack p_49503_) {
        super.m_6402_(p_49499_, p_49500_, p_49501_, p_49502_, p_49503_);
        if (!p_49499_.f_46443_) {
            BlockPos blockpos = p_49500_.m_121945_((Direction)p_49501_.m_61143_((Property)FACING));
            p_49499_.m_7731_(p_49500_, (BlockState)p_49501_.m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(true)), 3);
            p_49499_.m_7731_(blockpos, (BlockState)((BlockState)p_49501_.m_61124_(PART, (Comparable)((Object)SarcophagusPart.HEAD))).m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(true)), 3);
            p_49499_.m_6289_(p_49500_, Blocks.f_50016_);
            p_49501_.m_60701_((LevelAccessor)p_49499_, p_49500_, 3);
        }
    }

    public BlockState m_6843_(BlockState p_51552_, Rotation p_51553_) {
        return (BlockState)p_51552_.m_61124_((Property)FACING, (Comparable)p_51553_.m_55954_((Direction)p_51552_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_54122_, Mirror p_54123_) {
        return p_54122_.m_60717_(p_54123_.m_54846_((Direction)p_54122_.m_61143_((Property)FACING)));
    }

    public long m_7799_(BlockState p_49522_, BlockPos p_49523_) {
        BlockPos blockpos = p_49523_.m_5484_((Direction)p_49522_.m_61143_((Property)FACING), p_49522_.m_61143_(PART) == SarcophagusPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)blockpos.m_123341_(), (int)p_49523_.m_123342_(), (int)blockpos.m_123343_());
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        SarcophagusPart bedPart = (SarcophagusPart)((Object)state.m_61143_(PART));
        return bedPart == SarcophagusPart.HEAD ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public void m_5707_(Level p_49505_, BlockPos p_49506_, BlockState p_49507_, Player p_49508_) {
        BlockPos blockpos;
        BlockState blockstate;
        SarcophagusPart part;
        if (!p_49505_.f_46443_ && p_49508_.m_7500_() && (part = (SarcophagusPart)((Object)p_49507_.m_61143_(PART))) == SarcophagusPart.FOOT && (blockstate = p_49505_.m_8055_(blockpos = p_49506_.m_121945_(SarcophagusBlock.getNeighbourDirection(part, (Direction)p_49507_.m_61143_((Property)FACING))))).m_60713_((Block)this) && blockstate.m_61143_(PART) == SarcophagusPart.HEAD) {
            p_49505_.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            p_49505_.m_5898_(p_49508_, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        super.m_5707_(p_49505_, p_49506_, p_49507_, p_49508_);
    }

    public void m_6810_(BlockState p_51538_, Level p_51539_, BlockPos p_51540_, BlockState p_51541_, boolean p_51542_) {
        if (!p_51538_.m_60713_(p_51541_.m_60734_())) {
            BlockEntity blockentity = p_51539_.m_7702_(p_51540_);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)p_51539_, (BlockPos)p_51540_, (Container)((Container)blockentity));
                p_51539_.m_46717_(p_51540_, (Block)this);
            }
            super.m_6810_(p_51538_, p_51539_, p_51540_, p_51541_, p_51542_);
        }
    }

    public void tick(BlockState p_153059_, ServerLevel p_153060_, BlockPos p_153061_, Random p_153062_) {
        BlockEntity blockentity = p_153060_.m_7702_(p_153061_);
        if (blockentity instanceof SarcophagusBlockEntity) {
            ((SarcophagusBlockEntity)blockentity).recheckOpen();
        }
    }

    public BlockEntity m_142194_(BlockPos p_153064_, BlockState p_153065_) {
        return new SarcophagusBlockEntity(p_153064_, p_153065_);
    }

    public RenderShape m_7514_(BlockState p_51567_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_49479_) {
        FluidState fluidstate = p_49479_.m_43725_().m_6425_(p_49479_.m_8083_());
        Direction direction = p_49479_.m_8125_();
        BlockPos blockpos = p_49479_.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        Level level = p_49479_.m_43725_();
        return level.m_8055_(blockpos1).m_60629_(p_49479_) && level.m_6857_().m_61937_(blockpos1) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_)) : null;
    }

    public static Direction getConnectedDirection(BlockState p_51585_) {
        Direction direction = (Direction)p_51585_.m_61143_((Property)FACING);
        return p_51585_.m_61143_(PART) == SarcophagusPart.HEAD ? direction.m_122424_() : direction;
    }

    public String getLid() {
        return this.lidRL;
    }

    public String getBase() {
        return this.baseRL;
    }

    public static DoubleBlockCombiner.Combiner<SarcophagusBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity p_51518_) {
        return new DoubleBlockCombiner.Combiner<SarcophagusBlockEntity, Float2FloatFunction>(){

            public Float2FloatFunction acceptDouble(SarcophagusBlockEntity p_51633_, SarcophagusBlockEntity p_51634_) {
                return p_51638_ -> Math.max(p_51633_.m_6683_(p_51638_), p_51634_.m_6683_(p_51638_));
            }

            public Float2FloatFunction acceptSingle(SarcophagusBlockEntity p_51631_) {
                return p_51631_::m_6683_;
            }

            public Float2FloatFunction acceptNone() {
                return arg_0 -> ((LidBlockEntity)p_51518_).m_6683_(arg_0);
            }
        };
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153055_, BlockState p_153056_, BlockEntityType<T> p_153057_) {
        return p_153055_.f_46443_ ? SarcophagusBlock.m_152132_(p_153057_, this.blockEntityType(), SarcophagusBlockEntity::lidAnimateTick) : null;
    }

    @Override
    public DoubleBlockCombiner.NeighborCombineResult<? extends SarcophagusBlockEntity> combine(BlockState p_51544_, Level p_51545_, BlockPos p_51546_, boolean p_51547_) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = (world, pos) -> false;
        return DoubleBlockCombiner.m_52822_((BlockEntityType)((BlockEntityType)this.blockEntityType.get()), SarcophagusBlock::getBlockType, SarcophagusBlock::getConnectedDirection, (DirectionProperty)FACING, (BlockState)p_51544_, (LevelAccessor)p_51545_, (BlockPos)p_51546_, bipredicate);
    }

    public BlockEntityType<? extends SarcophagusBlockEntity> blockEntityType() {
        return (BlockEntityType)this.blockEntityType.get();
    }
}

