/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntryRenderHelper;
import fuzs.pickupnotifier.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;

public abstract class DisplayEntry {
    public static final int ENTRY_HEIGHT = 18;
    private static final int TEXT_ITEM_MARGIN = 4;
    private static final DisplayEntryTextFactory RIGHT = (name, displayAmount, inventoryCount) -> {
        MutableComponent component = displayAmount > 1 || displayAmount == 1 && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount ? Component.m_237113_((String)(displayAmount + "x ")) : Component.m_237119_();
        component.m_7220_(name);
        if (inventoryCount > 0) {
            component.m_130946_(" ").m_7220_((Component)DisplayEntry.wrapInBrackets((Component)Component.m_237113_((String)String.valueOf(inventoryCount))));
        }
        return component;
    };
    private static final DisplayEntryTextFactory LEFT = (name, displayAmount, inventoryCount) -> {
        MutableComponent component = inventoryCount > 0 ? DisplayEntry.wrapInBrackets((Component)Component.m_237113_((String)String.valueOf(inventoryCount))).m_130946_(" ") : Component.m_237119_();
        component.m_7220_(name);
        if (displayAmount > 1 || displayAmount == 1 && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount) {
            component.m_7220_((Component)Component.m_237113_((String)(" x" + displayAmount)));
        }
        return component;
    };
    private final Rarity rarity;
    private int remainingTicks;
    private int displayAmount;
    private Component component;

    protected DisplayEntry(int displayAmount, Rarity rarity) {
        this.displayAmount = displayAmount;
        this.rarity = rarity;
        this.resetEntry();
    }

    private static MutableComponent wrapInBrackets(Component toWrap) {
        return Component.m_237113_((String)"(").m_7220_(toWrap).m_130946_(")");
    }

    public int getRemainingTicks() {
        return this.remainingTicks;
    }

    public int getDisplayAmount() {
        return this.displayAmount;
    }

    public boolean mayDiscard() {
        return this.remainingTicks <= 0;
    }

    public void tick() {
        if (this.remainingTicks > 0) {
            --this.remainingTicks;
        }
    }

    protected abstract Component getEntryName();

    protected abstract int getInventoryCount(Inventory var1);

    public Component getTextComponent(Player player) {
        if (this.component == null) {
            DisplayEntryTextFactory factory = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.mirrored() ? RIGHT : LEFT;
            int displayAmount = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.text() ? this.getDisplayAmount() : 0;
            int inventoryCount = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.inventoryCount ? this.getInventoryCount(player.m_150109_()) : 0;
            this.component = factory.create(this.getEntryName(), displayAmount, inventoryCount).m_6270_(this.getComponentStyle());
        }
        return this.component;
    }

    private Style getComponentStyle() {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.ignoreRarity && this.rarity != Rarity.COMMON) {
            return Style.f_131099_.m_131140_(this.rarity.f_43022_);
        }
        return Style.f_131099_.m_131140_(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.textColor);
    }

    public float getRemainingTicksRelative(float partialTicks) {
        float moveTime = Math.min(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.moveTime, ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime);
        return 1.0f - Mth.m_14036_((float)(((float)this.remainingTicks - partialTicks) / moveTime), (float)0.0f, (float)1.0f);
    }

    public void resetEntry() {
        this.remainingTicks = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime;
        this.component = null;
    }

    public abstract boolean mayMergeWith(DisplayEntry var1);

    public void mergeWith(DisplayEntry other) {
        this.displayAmount += other.displayAmount;
        this.resetEntry();
    }

    public int getEntryWidth(Minecraft minecraft) {
        int textWidth = minecraft.f_91062_.m_92852_((FormattedText)this.getTextComponent((Player)minecraft.f_91074_));
        return ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite ? textWidth + 4 + 16 : textWidth;
    }

    public void render(Minecraft minecraft, PoseStack poseStack, int posX, int posY, float alpha, float scale) {
        int fadeTime;
        boolean mirrorPosition = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.mirrored();
        boolean withSprite = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite;
        int posXSide = mirrorPosition || !withSprite ? posX : posX + 16 + 4;
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        this.renderBg(minecraft, poseStack, posX, posY, alpha);
        int n = fadeTime = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.fadeAway ? 255 - (int)(255.0f * alpha) : 255;
        if (fadeTime >= 5) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            GuiComponent.m_93243_((PoseStack)poseStack, (Font)minecraft.f_91062_, (Component)this.getTextComponent((Player)minecraft.f_91074_), (int)posXSide, (int)(posY + 4), (int)(0xFFFFFF | fadeTime << 24));
            if (withSprite) {
                int textWidth = minecraft.f_91062_.m_92852_((FormattedText)this.getTextComponent((Player)minecraft.f_91074_));
                this.renderSprite(minecraft, poseStack, mirrorPosition ? posX + textWidth + 4 : posX, posY, scale);
            }
            RenderSystem.m_69461_();
        }
        poseStack.m_85849_();
    }

    private void renderBg(Minecraft minecraft, PoseStack poseStack, int posX, int posY, float alpha) {
        switch (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.background) {
            case BLACK: {
                int backgroundOpacity = (int)((Double)minecraft.f_91066_.m_232104_().m_231551_() * (double)(1.0f - alpha) * 255.0) << 24 & 0xFF000000;
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(posX - 3), (int)posY, (int)(posX + this.getEntryWidth(minecraft) + 5), (int)(posY + 16), (int)backgroundOpacity);
                break;
            }
            case TOOLTIP: {
                DisplayEntryRenderHelper.renderTooltipInternal(poseStack, posX, posY + 3, this.getEntryWidth(minecraft), 9, (int)((1.0f - alpha) * 255.0f));
            }
        }
    }

    protected abstract void renderSprite(Minecraft var1, PoseStack var2, int var3, int var4, float var5);

    @FunctionalInterface
    private static interface DisplayEntryTextFactory {
        public MutableComponent create(Component var1, int var2, int var3);
    }
}

