/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.handler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.PositionPreset;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.client.util.PickUpCollector;
import fuzs.pickupnotifier.config.ClientConfig;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableInt;

public class DrawEntriesHandler {
    public static final DrawEntriesHandler INSTANCE = new DrawEntriesHandler();
    private final PickUpCollector collector = new PickUpCollector();
    private final Int2ObjectArrayMap<MutableInt> handledEntities = new Int2ObjectArrayMap();

    private DrawEntriesHandler() {
    }

    public void addHandledEntity(int itemId) {
        this.handledEntities.put(itemId, (Object)new MutableInt());
    }

    public boolean isItemEntityHandled(int itemId) {
        return this.handledEntities.containsKey(itemId);
    }

    public PickUpCollector getCollector() {
        return this.collector;
    }

    public void onClientTick(Minecraft minecraft) {
        if (minecraft.m_91104_()) {
            return;
        }
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.forceClient && !this.handledEntities.isEmpty()) {
            this.handledEntities.values().forEach(MutableInt::increment);
            this.handledEntities.values().removeIf(time -> time.intValue() > 80);
        }
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime != 0 && !this.collector.isEmpty()) {
            this.collector.tick();
        }
    }

    public void onRenderGameOverlayText(Minecraft minecraft, PoseStack poseStack, float tickDelta) {
        if (this.collector.isEmpty()) {
            return;
        }
        float scale = (float)((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.scale / 6.0f;
        Window window = minecraft.m_91268_();
        int scaledWidth = (int)((float)window.m_85445_() / scale);
        int scaledHeight = (int)((float)window.m_85446_() / scale);
        PositionPreset position = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position;
        int posX = (int)((float)((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.offsetX / scale);
        int posY = (int)((float)((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.offsetY / scale);
        int offset = position.getY(18, scaledHeight, posY);
        int totalFade = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.move ? (int)(this.collector.getTotalFade(tickDelta) * 18.0) : 0;
        int entryY = offset + (position.bottom() ? totalFade : -totalFade);
        int entryHeight = position.bottom() ? 18 : -18;
        for (DisplayEntry entry : this.collector) {
            boolean mayRender = false;
            if (position.bottom()) {
                if (entryY < offset + entryHeight) {
                    mayRender = true;
                }
            } else if (entryY > offset + entryHeight) {
                mayRender = true;
            }
            if (mayRender) {
                int entryX = position.getX(entry.getEntryWidth(minecraft), scaledWidth, posX);
                float alpha = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.move ? Mth.m_14036_((float)((float)(entryY - offset) / (float)entryHeight), (float)0.0f, (float)1.0f) : entry.getRemainingTicksRelative(tickDelta);
                entry.render(minecraft, poseStack, entryX, entryY, alpha, scale);
            }
            entryY -= entryHeight;
        }
    }
}

