/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.init;

import fuzs.puzzleslib.core.ModLoader;
import fuzs.puzzleslib.init.RegistryReference;
import fuzs.puzzleslib.init.builder.ExtendedModMenuSupplier;
import fuzs.puzzleslib.init.builder.ModBlockEntityTypeBuilder;
import fuzs.puzzleslib.init.builder.ModMenuSupplier;
import fuzs.puzzleslib.init.builder.ModPoiTypeBuilder;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public interface RegistryManager {
    public String namespace();

    public RegistryManager whenOn(ModLoader ... var1);

    default public RegistryManager whenNotOn(ModLoader ... forbiddenModLoaders) {
        ModLoader[] allowedModLoaders = (ModLoader[])Stream.of(ModLoader.values()).filter(modLoader -> !ArrayUtils.contains((Object[])forbiddenModLoaders, (Object)modLoader)).toArray(ModLoader[]::new);
        return this.whenOn(allowedModLoaders);
    }

    default public void applyRegistration() {
    }

    default public <T> RegistryReference<T> placeholder(ResourceKey<? extends Registry<? super T>> registryKey, String path) {
        return RegistryReference.placeholder(registryKey, this.makeKey(path));
    }

    public <T> RegistryReference<T> register(ResourceKey<? extends Registry<? super T>> var1, String var2, Supplier<T> var3);

    default public RegistryReference<Block> registerBlock(String path, Supplier<Block> entry) {
        return this.register(Registry.f_122901_, path, entry);
    }

    default public RegistryReference<Block> registerBlockWithItem(String path, Supplier<Block> entry, CreativeModeTab creativeTab) {
        return this.registerBlockWithItem(path, entry, new Item.Properties().m_41491_(creativeTab));
    }

    default public RegistryReference<Block> registerBlockWithItem(String path, Supplier<Block> entry, Item.Properties properties) {
        RegistryReference<Block> block = this.registerBlock(path, entry);
        this.registerBlockItem(path, properties);
        return block;
    }

    default public RegistryReference<Fluid> registerFluid(String path, Supplier<Fluid> entry) {
        return this.register(Registry.f_122899_, path, entry);
    }

    default public RegistryReference<Item> registerItem(String path, Function<Item.Properties, Item> entry, CreativeModeTab creativeTab) {
        return this.registerItem(path, () -> (Item)entry.apply(new Item.Properties().m_41491_(creativeTab)));
    }

    default public RegistryReference<Item> registerItem(String path, Supplier<Item> entry) {
        return this.register(Registry.f_122904_, path, entry);
    }

    default public RegistryReference<Item> registerBlockItem(String path, CreativeModeTab creativeTab) {
        return this.registerBlockItem(path, new Item.Properties().m_41491_(creativeTab));
    }

    default public RegistryReference<Item> registerBlockItem(String path, Item.Properties properties) {
        return this.registerItem(path, () -> {
            Block block = (Block)Registry.f_122824_.m_7745_(this.makeKey(path));
            Objects.requireNonNull(block, "Can't register item for null block");
            return new BlockItem(block, properties);
        });
    }

    default public RegistryReference<MobEffect> registerMobEffect(String path, Supplier<MobEffect> entry) {
        return this.register(Registry.f_122900_, path, entry);
    }

    default public RegistryReference<SoundEvent> registerRawSoundEvent(String path) {
        return this.registerSoundEvent(path, () -> new SoundEvent(this.makeKey(path)));
    }

    default public RegistryReference<SoundEvent> registerSoundEvent(String path, Supplier<SoundEvent> entry) {
        return this.register(Registry.f_122898_, path, entry);
    }

    default public RegistryReference<Potion> registerPotion(String path, Supplier<Potion> entry) {
        return this.register(Registry.f_122905_, path, entry);
    }

    default public RegistryReference<Enchantment> registerEnchantment(String path, Supplier<Enchantment> entry) {
        return this.register(Registry.f_122902_, path, entry);
    }

    default public <T extends Entity> RegistryReference<EntityType<T>> registerEntityType(String path, Supplier<EntityType<T>> entry) {
        return this.register(Registry.f_122903_, path, entry);
    }

    default public <T extends Entity> RegistryReference<EntityType<T>> registerEntityTypeBuilder(String path, Supplier<EntityType.Builder<T>> entry) {
        return this.registerEntityType(path, () -> ((EntityType.Builder)entry.get()).m_20712_(path));
    }

    default public <T extends BlockEntity> RegistryReference<BlockEntityType<T>> registerBlockEntityType(String path, Supplier<BlockEntityType<T>> entry) {
        return this.register(Registry.f_122907_, path, entry);
    }

    public <T extends BlockEntity> RegistryReference<BlockEntityType<T>> registerBlockEntityTypeBuilder(String var1, Supplier<ModBlockEntityTypeBuilder<T>> var2);

    default public <T extends AbstractContainerMenu> RegistryReference<MenuType<T>> registerMenuType(String path, Supplier<MenuType<T>> entry) {
        return this.register(Registry.f_122913_, path, entry);
    }

    public <T extends AbstractContainerMenu> RegistryReference<MenuType<T>> registerMenuTypeSupplier(String var1, Supplier<ModMenuSupplier<T>> var2);

    public <T extends AbstractContainerMenu> RegistryReference<MenuType<T>> registerExtendedMenuTypeSupplier(String var1, Supplier<ExtendedModMenuSupplier<T>> var2);

    public RegistryReference<PoiType> registerPoiTypeBuilder(String var1, Supplier<ModPoiTypeBuilder> var2);

    default public <T extends Recipe<?>> RegistryReference<RecipeType<T>> registerRecipeType(final String path) {
        return this.register(Registry.f_122914_, path, () -> new RecipeType<T>(){
            private final String id;
            {
                this.id = RegistryManager.this.makeKey(path).toString();
            }

            public String toString() {
                return this.id;
            }
        });
    }

    default public ResourceLocation makeKey(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Can't register object without name");
        }
        return new ResourceLocation(this.namespace(), path);
    }
}

