/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.whats_that_slot.ui.action;

import dev.gegy.whats_that_slot.mixin.AbstractContainerScreenAccess;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;

public final class ScreenSlotActions {
    private final List<Action> actions = new ArrayList<Action>();

    public ScreenSlotActions swapStacks(Slot sourceSlot, Slot targetSlot) {
        if (sourceSlot == targetSlot) {
            return this;
        }
        if (!targetSlot.m_5857_(sourceSlot.m_7993_())) {
            return this;
        }
        this.clickSlot(sourceSlot);
        this.clickSlot(targetSlot);
        if (targetSlot.m_6657_() && sourceSlot.m_5857_(targetSlot.m_7993_())) {
            this.clickSlot(sourceSlot);
        }
        return this;
    }

    public ScreenSlotActions clickSlot(Slot slot) {
        this.actions.add((screen, screenAccess) -> screenAccess.invokeSlotClicked(slot, slot.f_40219_, 0, ClickType.PICKUP));
        return this;
    }

    public void execute(AbstractContainerScreen<?> screen) {
        Minecraft client = Minecraft.m_91087_();
        this.executeNextAction(client, screen, this.actions.iterator());
    }

    private void executeNextAction(Minecraft client, AbstractContainerScreen<?> screen, Iterator<Action> iterator) {
        if (iterator.hasNext()) {
            Action action = iterator.next();
            action.run(screen, (AbstractContainerScreenAccess)screen);
            client.m_6937_(() -> this.executeNextAction(client, screen, iterator));
        }
    }

    public static interface Action {
        public void run(AbstractContainerScreen<?> var1, AbstractContainerScreenAccess var2);
    }
}

