/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.whats_that_slot.ui.action;

import dev.gegy.whats_that_slot.mixin.AbstractContainerScreenAccess;
import dev.gegy.whats_that_slot.query.QueriedItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public record SlotSelector(List<Slot> slots) {
    public static SlotSelector of(AbstractContainerMenu menu) {
        ArrayList<Slot> sortedSlots = new ArrayList<Slot>((Collection<Slot>)menu.f_38839_);
        sortedSlots.sort(Comparator.comparingInt(slot -> SlotSelector.isPlayerSlot(slot) ? 0 : 1));
        return new SlotSelector(sortedSlots);
    }

    public static SlotSelector of(AbstractContainerScreen<?> screen) {
        AbstractContainerMenu menu = ((AbstractContainerScreenAccess)screen).getMenu();
        return SlotSelector.of(menu);
    }

    @Nullable
    public Slot selectMatching(QueriedItem queriedItem) {
        for (Slot slot : this.slots) {
            if (!queriedItem.matches(slot.m_7993_())) continue;
            return slot;
        }
        return null;
    }

    private static boolean isPlayerSlot(Slot slot) {
        return slot.f_40218_ instanceof Inventory;
    }
}

