/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.whats_that_slot.ui.state;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.gegy.whats_that_slot.query.SlotQuery;
import dev.gegy.whats_that_slot.query.SlotQueryGenerator;
import dev.gegy.whats_that_slot.ui.SlotQueryProgressBar;
import dev.gegy.whats_that_slot.ui.state.ActiveQueryState;
import dev.gegy.whats_that_slot.ui.state.IdleQueryState;
import dev.gegy.whats_that_slot.ui.state.SlotQueryState;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;

public final class RequestingQueryState
implements SlotQueryState {
    private static final Duration QUERY_TIME_PER_TICK = Duration.ofMillis(10L);
    private final AbstractContainerScreen<?> screen;
    private final Slot slot;
    private final SlotQueryGenerator query;
    private final SlotQueryProgressBar progressBar;
    private int ticks;

    public RequestingQueryState(AbstractContainerScreen<?> screen, Slot slot) {
        this.screen = screen;
        this.slot = slot;
        this.query = SlotQuery.forSlot(screen, slot);
        this.progressBar = new SlotQueryProgressBar(screen, slot);
    }

    @Override
    @Nonnull
    public SlotQueryState tick(@Nullable Slot focusedSlot, boolean requestingQuery) {
        Slot queryingSlot;
        Object object = queryingSlot = requestingQuery ? focusedSlot : null;
        if (queryingSlot != this.slot) {
            return new IdleQueryState(this.screen);
        }
        this.query.advanceFor(QUERY_TIME_PER_TICK);
        if (++this.ticks >= 20) {
            return new ActiveQueryState(this.screen, this.slot, this.query.build());
        }
        return this;
    }

    @Override
    public void draw(PoseStack matrices, int mouseX, int mouseY, float delta) {
        float queryProgress = this.getQueryProgress(delta);
        this.progressBar.draw(matrices, queryProgress);
    }

    private float getQueryProgress(float delta) {
        return Math.min((float)this.ticks + delta, 20.0f) / 20.0f;
    }
}

