/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.whats_that_slot.ui.window;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.gegy.whats_that_slot.query.SlotQuery;
import dev.gegy.whats_that_slot.ui.Bounds2i;
import dev.gegy.whats_that_slot.ui.scroll.ScrollView;
import dev.gegy.whats_that_slot.ui.window.SlotGridLayout;
import dev.gegy.whats_that_slot.ui.window.SlotQueryActions;
import dev.gegy.whats_that_slot.ui.window.texture.ScrolledSlotQueryWindow;
import dev.gegy.whats_that_slot.ui.window.texture.SlotQueryWindow;
import dev.gegy.whats_that_slot.ui.window.texture.StaticSlotQueryWindow;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class SlotQueryPopup
extends GuiComponent {
    public static final int BLIT_OFFSET = 200;
    public static final int SLOTS_COUNT_X = 5;
    public static final int MAX_SLOTS_COUNT_Y = 5;
    private final SlotQueryWindow window;
    private final Bounds2i bounds;
    private boolean selected;

    public SlotQueryPopup(AbstractContainerScreen<?> screen, Slot queriedSlot, SlotQuery query) {
        SlotQueryActions actions = SlotQueryActions.create(screen, queriedSlot);
        this.window = this.createWindow(actions, query);
        this.bounds = SlotQueryWindow.findPopupBounds(screen, this.window.bounds(), queriedSlot);
        this.m_93250_(200);
    }

    private SlotQueryWindow createWindow(SlotQueryActions actions, SlotQuery query) {
        int itemCount = query.items().size();
        SlotGridLayout grid = SlotGridLayout.createVertical(5, 5, itemCount);
        ScrollView scrollView = grid.createScrollView(itemCount);
        if (scrollView.canScroll()) {
            return new ScrolledSlotQueryWindow(actions, grid, query, scrollView);
        }
        return new StaticSlotQueryWindow(actions, grid, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(PoseStack matrices, int mouseX, int mouseY) {
        PoseStack modelViewMatrices = RenderSystem.m_157191_();
        try {
            modelViewMatrices.m_85836_();
            modelViewMatrices.m_85837_((double)this.bounds.x0(), (double)this.bounds.y0(), (double)this.m_93252_());
            RenderSystem.m_157182_();
            this.window.draw(matrices, mouseX - this.bounds.x0(), mouseY - this.bounds.y0());
        }
        finally {
            modelViewMatrices.m_85849_();
            RenderSystem.m_157182_();
        }
    }

    public boolean isSelected(double mouseX, double mouseY) {
        return this.bounds.contains(mouseX, mouseY) || this.selected;
    }

    public boolean mouseClicked(double mouseX, double mouseY) {
        if (this.isSelected(mouseX, mouseY)) {
            if (this.window.mouseClicked(mouseX - (double)this.bounds.x0(), mouseY - (double)this.bounds.y0())) {
                this.selected = true;
            }
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY) {
        if (this.selected) {
            this.window.mouseDragged(mouseX - (double)this.bounds.x0(), mouseY - (double)this.bounds.y0());
            return true;
        }
        return this.isSelected(mouseX, mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY) {
        if (this.selected) {
            this.selected = false;
            this.window.mouseReleased(mouseX - (double)this.bounds.x0(), mouseY - (double)this.bounds.y0());
            return true;
        }
        return this.isSelected(mouseX, mouseY);
    }

    public boolean mouseScrolled(double amount) {
        this.window.mouseScrolled(amount);
        return true;
    }

    @Nonnull
    public ItemStack getHoveredItemAt(double x, double y) {
        return this.window.getHoveredItemAt(x - (double)this.bounds.x0(), y - (double)this.bounds.y0());
    }
}

