/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.whats_that_slot.ui.window.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.gegy.whats_that_slot.query.QueriedItem;
import dev.gegy.whats_that_slot.query.SlotQuery;
import dev.gegy.whats_that_slot.ui.Bounds2i;
import dev.gegy.whats_that_slot.ui.window.SlotGridLayout;
import dev.gegy.whats_that_slot.ui.window.SlotQueryActions;
import dev.gegy.whats_that_slot.ui.window.SlotQueryItems;
import dev.gegy.whats_that_slot.ui.window.texture.SlotQueryWindow;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class StaticSlotQueryWindow
extends GuiComponent
implements SlotQueryWindow {
    private static final ResourceLocation TEXTURE = new ResourceLocation("whats_that_slot", "textures/gui/static_window.png");
    private static final int TEXTURE_WIDTH = 128;
    private static final int TEXTURE_HEIGHT = 128;
    private static final int WIDTH = 102;
    private static final int SLOT_SIZE = 18;
    private static final int SLOTS_X0 = 7;
    private static final int SLOTS_Y0 = 7;
    private static final int BORDER = 6;
    private final SlotQueryActions actions;
    private final SlotGridLayout grid;
    private final SlotQueryItems items;

    public StaticSlotQueryWindow(SlotQueryActions actions, SlotGridLayout grid, SlotQuery query) {
        this.actions = actions;
        this.grid = grid;
        Bounds2i slotsBounds = grid.screenBounds(7, 7);
        this.items = new SlotQueryItems(slotsBounds, grid, query.items());
        this.m_93250_(200);
    }

    @Override
    public void draw(PoseStack matrices, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.drawBackground(matrices);
        this.items.drawItems(matrices);
        this.items.drawTooltips(matrices, mouseX, mouseY);
    }

    private void drawBackground(PoseStack matrices) {
        this.m_93228_(matrices, 0, 0, 0, 0, 102, 6);
        for (int i = 0; i < this.grid.countY(); ++i) {
            this.m_93228_(matrices, 0, 6 + i * 18, 0, 6, 102, 18);
        }
        this.m_93228_(matrices, 0, 6 + this.grid.countY() * 18, 0, 24, 102, 6);
    }

    @Override
    public Bounds2i bounds() {
        return Bounds2i.ofSize(0, 0, 102, 12 + this.grid.screenHeight());
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY) {
        QueriedItem queriedItem = this.items.mouseClicked(mouseX, mouseY);
        if (queriedItem != null) {
            return this.actions.selectItem(queriedItem);
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack getHoveredItemAt(double x, double y) {
        return this.items.getHoveredItemAt(x, y);
    }

    public void m_93228_(PoseStack matrices, int x, int y, int u, int v, int width, int height) {
        StaticSlotQueryWindow.m_93143_((PoseStack)matrices, (int)x, (int)y, (int)this.m_93252_(), (float)u, (float)v, (int)width, (int)height, (int)128, (int)128);
    }
}

